IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CPJ_Turnos_Generar]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CPJ_Turnos_Generar] 
END
GO

CREATE PROCEDURE [dbo].[CPJ_Turnos_Generar]		@pJson VARCHAR(8000)
AS 
SET NOCOUNT ON 

/*Variables recibidas por parmetro a traves del JSON*/
DECLARE @pFlagUsarTrans			TINYINT
DECLARE @pModoDebug				TINYINT
DECLARE @pId_Usuario			SMALLINT
DECLARE @pId_Sector				SMALLINT
DECLARE @pId_Recurso			INT
DECLARE @pFecha_Desde			DATETIME
DECLARE @pFecha_Hasta			DATETIME
DECLARE @pId_Contrato           INT

SET @pFlagUsarTrans			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Usuario			= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Usuario')), 0)
SET @pId_Sector				= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Sector')), 0)
SET @pId_Recurso			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Recurso')), 0)
SET @pFecha_Desde			= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Desde')), '19000101')
SET @pFecha_Hasta			= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Hasta')), '19000101')
SET @pId_Contrato			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Contrato')), 0)
/*FIN Variables recibidas por parmetro a traves del JSON*/

/*Variables Locales*/
DECLARE @cadaDiaAGenerar					DATETIME
DECLARE @Id_Recurso							INT
DECLARE @Id_Recurso_Horario					INT
DECLARE @Dia_De_La_Semana					VARCHAR(50)
DECLARE @Hora_Inicio						DATETIME
DECLARE @Hora_Fin							DATETIME
DECLARE @Frecuencia							INT
DECLARE @cadaMinutoAGenerar					DATETIME
DECLARE @fechaCompletaAGenerar				DATETIME
DECLARE @Flag_Id_Recurso_Bloq				INT
DECLARE @Cantidad_Turnos_Generados 			INT
DECLARE @Flag_Ya_Existe_Turno				TINYINT
DECLARE @Cupo_Max_Compartido				INT
DECLARE @Cant_Cupo_Compartido_Generados 	INT
DECLARE @Agregar_Contratos 					TINYINT
/*FIN Variables Locales*/

BEGIN TRY
	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Turnos_Generar'
		PRINT 'Parametros: '+ @pJson  
	END
	
	/*===================================================================*/	
	
	SET @Cantidad_Turnos_Generados = 0
	
	/*===================================================================*/	
	
	IF @pFecha_Desde = 0 RAISERROR ('Parameter "Fecha_Desde" mandatory', 16,  1)
	IF @pFecha_Hasta = 0 RAISERROR ('Parameter "Fecha_Hasta" mandatory', 16,  1)
	IF @pFecha_Desde >= @pFecha_Hasta  RAISERROR ('Parameter "Fecha_Hasta" greater than or equal Parameter "Fecha_Desde"', 16,  1)
	
	IF(@pId_Sector = 0 AND @pId_Recurso = 0 AND @pId_Contrato = 0)
	BEGIN
		IF @pId_Sector = 0 RAISERROR ('Parameter "Id_Sector" mandatory', 16,  1)
		IF @pId_Recurso = 0 RAISERROR ('Parameter "Id_Recurso" mandatory', 16,  1)
		IF @pId_Contrato = 0 RAISERROR ('Parameter "Id_Contrato" mandatory', 16,  1)
	END		
	
	--Primer dia a generar
	SET @cadaDiaAGenerar = @pFecha_Desde	
	
	WHILE(@cadaDiaAGenerar <= @pFecha_Hasta)
	BEGIN		
		SET @Dia_De_La_Semana = DATENAME(WEEKDAY, @cadaDiaAGenerar) --Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday
		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'Dia: ' + @Dia_De_La_Semana + '(' + CONVERT(VARCHAR(10), @cadaDiaAGenerar, 102) + ')'
		END
		
		--POR SECTOR
		IF(@pId_Sector <> 0 AND @pId_Recurso = 0)
		BEGIN
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Generacion POR SECTOR. pId_Sector: ' + CONVERT(VARCHAR(10), @pId_Sector)
			END
			--Recorro todos los recursos que tiene el sector		
			DECLARE curGenerarRecursosxDia CURSOR FOR
			SELECT Id_Recurso 
			FROM Empresas_Sedes_Sec_Recursos
			WHERE
			Activo = 1
			AND Id_Sector = @pId_Sector

			OPEN curGenerarRecursosxDia
			FETCH NEXT FROM curGenerarRecursosxDia INTO @Id_Recurso
			WHILE @@FETCH_STATUS = 0
			BEGIN
				IF(@pModoDebug = 1)
				BEGIN
					PRINT 'Id_Recurso: ' + CONVERT(VARCHAR(10), @Id_Recurso)
				END
				
				--Recorro todos los horarios que tiene el recurso
				DECLARE curGenerarRecursosxDiaxHorario CURSOR FOR
				SELECT Id_Recurso_Horario, Hora_Inicio, Hora_Fin, Frecuencia, ISNULL(Cupo_Max_Compartido, 0)
				FROM Empresas_Sedes_Sec_Recuros_Horarios
				WHERE
				Activo = 1
				AND Id_Recurso = @Id_Recurso
				AND (	(ISNULL(Lunes, 0) = 1  AND (@Dia_De_La_Semana = 'Monday'  OR  @Dia_De_La_Semana = 'Lunes'))  OR
						(ISNULL(Martes, 0) = 1 AND (@Dia_De_La_Semana = 'Tuesday' OR  @Dia_De_La_Semana = 'Martes')) OR
						(ISNULL(Miercoles, 0) = 1 AND (@Dia_De_La_Semana = 'Wednesday' OR @Dia_De_La_Semana = 'Miercoles' OR @Dia_De_La_Semana = 'Mi'+ CHAR(233) +'rcoles')) OR
						(ISNULL(Jueves, 0) = 1  AND (@Dia_De_La_Semana = 'Thursday' OR  @Dia_De_La_Semana = 'Jueves')) OR
						(ISNULL(Viernes, 0) = 1 AND (@Dia_De_La_Semana = 'Friday' OR @Dia_De_La_Semana = 'Viernes')) OR
						(ISNULL(Sabado, 0) = 1  AND (@Dia_De_La_Semana = 'Saturday'  OR @Dia_De_La_Semana = 'Sabado' OR @Dia_De_La_Semana = 'S'+ CHAR(225) +'bado')) OR
						(ISNULL(Domingo, 0) = 1 AND (@Dia_De_La_Semana = 'Sunday' OR @Dia_De_La_Semana = 'Domingo'))
					)
				
				SET @Cant_Cupo_Compartido_Generados = 0

				OPEN curGenerarRecursosxDiaxHorario
				FETCH NEXT FROM curGenerarRecursosxDiaxHorario INTO @Id_Recurso_Horario, @Hora_Inicio, @Hora_Fin, @Frecuencia, @Cupo_Max_Compartido
				WHILE @@FETCH_STATUS = 0
				BEGIN
					IF(@pModoDebug = 1)
					BEGIN
						PRINT 'Id_Recurso_Horario: ' + CONVERT(VARCHAR(10), @Id_Recurso_Horario) + ' Hora_Inicio: ' + CONVERT(VARCHAR(5), @Hora_Inicio, 8) + ' Hora_Fin: ' + CONVERT(VARCHAR(5), @Hora_Fin, 8) + ' Frecuencia: ' + CONVERT(VARCHAR(10), @Frecuencia) + ' Cupo_Max_Compartido:' + CONVERT(VARCHAR(10), @Cupo_Max_Compartido)
					END
					
					--Hora inicio Ej: Ej. 1900-01-01T10:00:00
					--Hora fin Ej: Ej. 1900-01-01T10:50:00
					
					-- Primer Minuto a generar (Ej. 1900-01-01T10:00:00)				
					SET @cadaMinutoAGenerar = @Hora_Inicio
					
					WHILE (@cadaMinutoAGenerar <= @Hora_Fin)
					BEGIN
						IF(@pModoDebug = 1)
						BEGIN
							PRINT 'Hora: ' + CONVERT(VARCHAR(5), @cadaMinutoAGenerar, 8)
						END
						
						SET @Flag_Id_Recurso_Bloq = ISNULL((SELECT Id_Recurso_Bloq 
															FROM Empresas_Sedes_Sec_Recuros_Bloqueos 
															WHERE 
															Activo = 1
															AND Id_Recurso = @Id_Recurso 
															AND ((ISNULL(Lunes, 0) = 1 AND (@Dia_De_La_Semana = 'Monday' OR  @Dia_De_La_Semana = 'Lunes')) OR
																(ISNULL(Martes, 0) = 1 AND (@Dia_De_La_Semana = 'Tuesday' OR  @Dia_De_La_Semana = 'Martes')) OR
																(ISNULL(Miercoles, 0) = 1 AND (@Dia_De_La_Semana = 'Wednesday' OR  @Dia_De_La_Semana = 'Miercoles' OR @Dia_De_La_Semana = 'Mi'+ CHAR(233) +'rcoles')) OR
																(ISNULL(Jueves, 0) = 1  AND (@Dia_De_La_Semana = 'Thursday' OR  @Dia_De_La_Semana = 'Jueves')) OR
																(ISNULL(Viernes, 0) = 1 AND (@Dia_De_La_Semana = 'Friday' OR  @Dia_De_La_Semana = 'Viernes')) OR
																(ISNULL(Sabado, 0) = 1  AND (@Dia_De_La_Semana = 'Saturday' OR  @Dia_De_La_Semana = 'Sabado' OR @Dia_De_La_Semana = 'S'+ CHAR(225) +'bado')) OR
																(ISNULL(Domingo, 0) = 1 AND (@Dia_De_La_Semana = 'Sunday' OR  @Dia_De_La_Semana = 'Domingo'))
																)
															AND Hora_Inicio <= @cadaMinutoAGenerar
															AND Hora_Fin >= @cadaMinutoAGenerar)
															, 0)
						
						IF(@Flag_Id_Recurso_Bloq > 0)
						BEGIN
							IF(@pModoDebug = 1)
							BEGIN
								PRINT 'El recurso se encuentra bloqueado para la hora: ' + CONVERT(VARCHAR(5), @cadaMinutoAGenerar, 8) + ' a traves del Id_Recurso_Bloq = ' + CONVERT(VARCHAR(10), @Flag_Id_Recurso_Bloq)
							END
						END
						ELSE
						BEGIN					
							SET @fechaCompletaAGenerar = CONVERT(DATETIME, 
																		CAST(DATEPART(yy, @cadaDiaAGenerar) AS CHAR(4)) + '-' + RIGHT('00' + CAST(DATEPART(mm, @cadaDiaAGenerar) AS VARCHAR), 2) + '-' + RIGHT('00' + CAST(DATEPART(dd, @cadaDiaAGenerar) AS VARCHAR), 2) 
																		+ 'T' + 
																		RIGHT('00' + CAST(DATEPART(HOUR, @cadaMinutoAGenerar) AS VARCHAR), 2) + ':' + RIGHT('00' + CAST(DATEPART(MINUTE, @cadaMinutoAGenerar) AS VARCHAR), 2) + ':' + '00'
																)
							
							IF(@pModoDebug = 1)
							BEGIN
								PRINT 'Fecha Completa a Generar: ' + CONVERT(VARCHAR(20), @fechaCompletaAGenerar, 120)
							END
							
							IF(@Cupo_Max_Compartido >= 2)
							BEGIN
								SET @Cant_Cupo_Compartido_Generados = (SELECT ISNULL((SELECT COUNT(1) FROM CRM_Turnos WHERE Id_Recurso = @Id_Recurso AND Fecha = @fechaCompletaAGenerar), 0))
								
								IF(@pModoDebug = 1)
								BEGIN
									PRINT '@Cant_Cupo_Compartido_Generados: ' + CONVERT(VARCHAR(10), @Cant_Cupo_Compartido_Generados) + ' de: ' + CONVERT(VARCHAR(10), @Cupo_Max_Compartido)
								END
								
								IF(@Cant_Cupo_Compartido_Generados >= @Cupo_Max_Compartido)
								BEGIN
									SET @Flag_Ya_Existe_Turno = 1
								END
							END
							ELSE
							BEGIN
								/*Si es un solo turno (es decir no es compartido)*/
								SET @Flag_Ya_Existe_Turno = (SELECT ISNULL((SELECT MAX(1) FROM CRM_Turnos WHERE Id_Recurso = @Id_Recurso AND Fecha = @fechaCompletaAGenerar), 0))
							END							
							
							IF(@pModoDebug = 1)
							BEGIN
								PRINT '@Flag_Ya_Existe_Turno: ' + CONVERT(VARCHAR(10), @Flag_Ya_Existe_Turno)
							END
							
							IF(@Flag_Ya_Existe_Turno = 1)
							BEGIN
								IF(@pModoDebug = 1)
								BEGIN
									PRINT 'Ya existia un turno generado (o todos los turnos compartidos) para el Id_Recurso: ' + CONVERT(VARCHAR(10), @Id_Recurso) + ' en la Fecha: ' + CONVERT(VARCHAR(20), @fechaCompletaAGenerar, 120)
								END
							END
							ELSE
							BEGIN
								IF(@Cupo_Max_Compartido = 0)
								BEGIN
									SET @Cupo_Max_Compartido = 1
								END
								
								SET @Cant_Cupo_Compartido_Generados = 1
								
								WHILE(@Cant_Cupo_Compartido_Generados <= @Cupo_Max_Compartido)
								BEGIN
									IF(@pModoDebug = 1)
									BEGIN
										PRINT 'Genera registro CRM_Turnos con los siguientes datos: Id_Usuario: ' + CONVERT(VARCHAR(10), @pId_Usuario) + '. Id_Recurso: ' + CONVERT(VARCHAR(10), @Id_Recurso) + ' Fecha: ' + CONVERT(VARCHAR(20), @fechaCompletaAGenerar, 120)
										PRINT '@Cant_Cupo_Compartido_Generados: ' + CONVERT(VARCHAR(10), @Cant_Cupo_Compartido_Generados) + ' de: ' + CONVERT(VARCHAR(10), @Cupo_Max_Compartido)
									END																		
									
									--Inserta el registro en CRM_Turnos
									SET @Cantidad_Turnos_Generados = @Cantidad_Turnos_Generados + 1
									
									INSERT INTO CRM_Turnos
									(Id_Usuario,			Id_Cliente,			Id_Recurso, 
									Fecha,					Descripcion,		Estado,
									Id_Trans,				Id_Recurso_Horario,	Frecuencia,
									Fecha_Generacion)
									VALUES
									(@pId_Usuario,			0,					@Id_Recurso,
									@fechaCompletaAGenerar,	'',					'',
									0,						@Id_Recurso_Horario,	@Frecuencia,
									GETDATE())
									
									SET @Cant_Cupo_Compartido_Generados = @Cant_Cupo_Compartido_Generados + 1
								END								
							END
						END
						
						--Siguiente minuto a generar
						SET @cadaMinutoAGenerar = DATEADD(MINUTE, @Frecuencia, @cadaMinutoAGenerar)
					END

					FETCH NEXT FROM curGenerarRecursosxDiaxHorario INTO @Id_Recurso_Horario, @Hora_Inicio, @Hora_Fin, @Frecuencia, @Cupo_Max_Compartido
				END
				CLOSE curGenerarRecursosxDiaxHorario
				DEALLOCATE curGenerarRecursosxDiaxHorario
				--FIN Recorro todos los horarios que tiene el recurso
				
				FETCH NEXT FROM curGenerarRecursosxDia INTO @Id_Recurso
			END
			CLOSE curGenerarRecursosxDia
			DEALLOCATE curGenerarRecursosxDia
			--FIN Recorro todos los recursos que tiene el sector
		END--IF(@pId_Sector <> 0)
		
		------------------------------------------------------------------------------------------------------------------
		
		--POR RECURSO
		IF(@pId_Recurso <> 0 AND @pId_Sector = 0)
		BEGIN
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Generacion POR RECURSO. pId_Recurso: ' + CONVERT(VARCHAR(10), @pId_Recurso)
			END
			
			--Recorro todos los horarios que tiene el recurso
			DECLARE curGenerarRecursosxDiaxHorario CURSOR FOR
			SELECT Id_Recurso_Horario, Hora_Inicio, Hora_Fin, Frecuencia, ISNULL(Cupo_Max_Compartido, 0)
			FROM Empresas_Sedes_Sec_Recuros_Horarios
			WHERE
			Activo = 1
			AND Id_Recurso = @pId_Recurso
			AND (	(ISNULL(Lunes, 0) = 1 AND (@Dia_De_La_Semana = 'Monday'  OR  @Dia_De_La_Semana = 'Lunes')) OR
					(ISNULL(Martes, 0) = 1 AND (@Dia_De_La_Semana = 'Tuesday' OR  @Dia_De_La_Semana = 'Martes')) OR
					(ISNULL(Miercoles, 0) = 1 AND (@Dia_De_La_Semana = 'Wednesday' OR  @Dia_De_La_Semana = 'Miercoles' OR @Dia_De_La_Semana = 'Mi'+ CHAR(233) +'rcoles')) OR
					(ISNULL(Jueves, 0) = 1 AND (@Dia_De_La_Semana = 'Thursday' OR  @Dia_De_La_Semana = 'Jueves')) OR
					(ISNULL(Viernes, 0) = 1 AND (@Dia_De_La_Semana = 'Friday' OR  @Dia_De_La_Semana = 'Viernes')) OR
					(ISNULL(Sabado, 0) = 1 AND (@Dia_De_La_Semana = 'Saturday' OR  @Dia_De_La_Semana = 'Sabado' OR  @Dia_De_La_Semana = 'S'+ CHAR(225) +'bado')) OR
					(ISNULL(Domingo, 0) = 1 AND (@Dia_De_La_Semana = 'Sunday' OR  @Dia_De_La_Semana = 'Domingo'))
				)
			
			SET @Cant_Cupo_Compartido_Generados = 0
			
			OPEN curGenerarRecursosxDiaxHorario
			FETCH NEXT FROM curGenerarRecursosxDiaxHorario INTO @Id_Recurso_Horario, @Hora_Inicio, @Hora_Fin, @Frecuencia, @Cupo_Max_Compartido
			WHILE @@FETCH_STATUS = 0
			BEGIN
				IF(@pModoDebug = 1)
				BEGIN
					PRINT 'Id_Recurso_Horario: ' + CONVERT(VARCHAR(10), @Id_Recurso_Horario) + ' Hora_Inicio: ' + CONVERT(VARCHAR(5), @Hora_Inicio, 8) + ' Hora_Fin: ' + CONVERT(VARCHAR(5), @Hora_Fin, 8) + ' Frecuencia: ' + CONVERT(VARCHAR(10), @Frecuencia)
				END
				
				--Hora inicio Ej: Ej. 1900-01-01T10:00:00
				--Hora fin Ej: Ej. 1900-01-01T10:50:00
				
				-- Primer Minuto a generar (Ej. 1900-01-01T10:00:00)				
				SET @cadaMinutoAGenerar = @Hora_Inicio
				
				WHILE (@cadaMinutoAGenerar <= @Hora_Fin)
				BEGIN
					IF(@pModoDebug = 1)
					BEGIN
						PRINT 'Hora: ' + CONVERT(VARCHAR(5), @cadaMinutoAGenerar, 8)
					END
					
					SET @Flag_Id_Recurso_Bloq = ISNULL((SELECT Id_Recurso_Bloq 
														FROM Empresas_Sedes_Sec_Recuros_Bloqueos 
														WHERE 
														Activo = 1
														AND Id_Recurso = @pId_Recurso 
														AND ((ISNULL(Lunes, 0) = 1 AND (@Dia_De_La_Semana = 'Monday'  OR  @Dia_De_La_Semana = 'Lunes')) OR
															(ISNULL(Martes, 0) = 1 AND (@Dia_De_La_Semana = 'Tuesday' OR  @Dia_De_La_Semana = 'Martes')) OR
															(ISNULL(Miercoles, 0) = 1 AND (@Dia_De_La_Semana = 'Wednesday' OR  @Dia_De_La_Semana = 'Miercoles' OR @Dia_De_La_Semana = 'Mi'+ CHAR(233) +'rcoles')) OR
															(ISNULL(Jueves, 0) = 1 AND (@Dia_De_La_Semana = 'Thursday' OR  @Dia_De_La_Semana = 'Jueves')) OR
															(ISNULL(Viernes, 0) = 1 AND (@Dia_De_La_Semana = 'Friday' OR  @Dia_De_La_Semana = 'Viernes')) OR
															(ISNULL(Sabado, 0) = 1 AND (@Dia_De_La_Semana = 'Saturday' OR  @Dia_De_La_Semana = 'Sabado' OR  @Dia_De_La_Semana = 'S'+ CHAR(225) +'bado')) OR
															(ISNULL(Domingo, 0) = 1 AND (@Dia_De_La_Semana = 'Sunday' OR  @Dia_De_La_Semana = 'Domingo'))
															)
														AND Hora_Inicio <= @cadaMinutoAGenerar
														AND Hora_Fin >= @cadaMinutoAGenerar)
														, 0)
					
					IF(@Flag_Id_Recurso_Bloq > 0)
					BEGIN
						IF(@pModoDebug = 1)
						BEGIN
							PRINT 'El recurso se encuentra bloqueado para la hora: ' + CONVERT(VARCHAR(5), @cadaMinutoAGenerar, 8) + ' a traves del Id_Recurso_Bloq = ' + CONVERT(VARCHAR(10), @Flag_Id_Recurso_Bloq)
						END
					END
					ELSE
					BEGIN					
						SET @fechaCompletaAGenerar = CONVERT(DATETIME, 
																	CAST(DATEPART(yy, @cadaDiaAGenerar) AS CHAR(4)) + '-' + RIGHT('00' + CAST(DATEPART(mm, @cadaDiaAGenerar) AS VARCHAR), 2) + '-' + RIGHT('00' + CAST(DATEPART(dd, @cadaDiaAGenerar) AS VARCHAR), 2) 
																	+ 'T' + 
																	RIGHT('00' + CAST(DATEPART(HOUR, @cadaMinutoAGenerar) AS VARCHAR), 2) + ':' + RIGHT('00' + CAST(DATEPART(MINUTE, @cadaMinutoAGenerar) AS VARCHAR), 2) + ':' + '00'
															)

						IF(@pModoDebug = 1)
						BEGIN
							PRINT 'Fecha Completa a Generar: ' + CONVERT(VARCHAR(20), @fechaCompletaAGenerar, 120)
						END
						
						IF(@Cupo_Max_Compartido >= 2)
						BEGIN
							SET @Cant_Cupo_Compartido_Generados = (SELECT ISNULL((SELECT COUNT(1) FROM CRM_Turnos WHERE Id_Recurso = @pId_Recurso AND Fecha = @fechaCompletaAGenerar), 0))

							IF(@pModoDebug = 1)
							BEGIN
								PRINT '@Cant_Cupo_Compartido_Generados: ' + CONVERT(VARCHAR(10), @Cant_Cupo_Compartido_Generados) + ' de: ' + CONVERT(VARCHAR(10), @Cupo_Max_Compartido)
							END

							IF(@Cant_Cupo_Compartido_Generados >= @Cupo_Max_Compartido)
							BEGIN
								SET @Flag_Ya_Existe_Turno = 1
							END
						END
						ELSE
						BEGIN
							/*Si es un solo turno (es decir no es compartido)*/
							SET @Flag_Ya_Existe_Turno = (SELECT ISNULL((SELECT MAX(1) FROM CRM_Turnos WHERE Id_Recurso = @pId_Recurso AND Fecha = @fechaCompletaAGenerar), 0))
						END		
	
						IF(@Flag_Ya_Existe_Turno = 1)
						BEGIN
							IF(@pModoDebug = 1)
							BEGIN
								PRINT 'Ya existia un turno (o todos los turnos compartidos) generado para el Id_Recurso: ' + CONVERT(VARCHAR(10), @pId_Recurso) + ' en la Fecha: ' + CONVERT(VARCHAR(20), @fechaCompletaAGenerar, 120)
							END
						END
						ELSE
						BEGIN						
							IF(@Cupo_Max_Compartido = 0)
							BEGIN
								SET @Cupo_Max_Compartido = 1
							END
							
							SET @Cant_Cupo_Compartido_Generados = 1
							
							WHILE(@Cant_Cupo_Compartido_Generados <= @Cupo_Max_Compartido)
							BEGIN
								IF(@pModoDebug = 1)
								BEGIN
									PRINT 'Genera registro CRM_Turnos con los siguientes datos: Id_Usuario: ' + CONVERT(VARCHAR(10), @pId_Usuario) + '. Id_Recurso: ' + CONVERT(VARCHAR(10), @pId_Recurso) + ' Fecha: ' + CONVERT(VARCHAR(20), @fechaCompletaAGenerar, 120)
									PRINT '@Cant_Cupo_Compartido_Generados: ' + CONVERT(VARCHAR(10), @Cant_Cupo_Compartido_Generados) + ' de: ' + CONVERT(VARCHAR(10), @Cupo_Max_Compartido)
								END
													
								--Inserta el registro en CRM_Turnos
								SET @Cantidad_Turnos_Generados = @Cantidad_Turnos_Generados + 1
								
								INSERT INTO CRM_Turnos
								(Id_Usuario,			Id_Cliente,			Id_Recurso, 
								Fecha,					Descripcion,		Estado,
								Id_Trans,				Id_Recurso_Horario,	Frecuencia,
								Fecha_Generacion)
								VALUES
								(@pId_Usuario,			0,					@pId_Recurso,
								@fechaCompletaAGenerar,	'',					'',
								0,						@Id_Recurso_Horario,@Frecuencia,
								GETDATE())
								
								SET @Cant_Cupo_Compartido_Generados = @Cant_Cupo_Compartido_Generados + 1
							END
						END
					END
					
					--Siguiente minuto a generar
					SET @cadaMinutoAGenerar = DATEADD(MINUTE, @Frecuencia, @cadaMinutoAGenerar)
				END

				FETCH NEXT FROM curGenerarRecursosxDiaxHorario INTO @Id_Recurso_Horario, @Hora_Inicio, @Hora_Fin, @Frecuencia, @Cupo_Max_Compartido
			END
			CLOSE curGenerarRecursosxDiaxHorario
			DEALLOCATE curGenerarRecursosxDiaxHorario
			--FIN Recorro todos los horarios que tiene el recurso
		END--IF(@pId_Recurso <> 0)
		
		--Siguiente Dia a generar
		SET @cadaDiaAGenerar = DATEADD(dd, 1, @cadaDiaAGenerar)
	END--WHILE(@cadaDiaAGenerar <= @pFecha_Hasta)


	/*===================================================================*/	
	--VALIDO SI EL CONTRATO TIENE TURNOS
	SET @Agregar_Contratos = (SELECT Valor_Integer FROM xParametros where SETDatos= 1 AND idParametro ='Generar_CRM_Turnos')
	IF(@pModoDebug = 1)
	BEGIN
		 PRINT '@Agregar_Contratos: ' + CONVERT(VARCHAR(10), @Agregar_Contratos)
	END
	
    IF @Agregar_Contratos = 1
	BEGIN
		IF @pId_Contrato <> 0
		BEGIN
			IF(@pModoDebug = 1)
			BEGIN
				 PRINT 'Elimina todos los turnos para el id_contrato: ' + CONVERT(VARCHAR(10), @pId_Contrato)
			END
				     
			DELETE CRM_TURNOS 
			WHERE 
			Id_Contrato = @pId_Contrato 
			AND Fecha >= @pFecha_Desde 
			AND Fecha < dateadd(dd,1,@pFecha_Hasta) 
		END
		ELSE
		BEGIN 
			IF(@pModoDebug = 1)
			BEGIN
				 PRINT 'Elimina todos los turnos que no tengan contrato' 
			END
			
			DELETE CRM_TURNOS 
			WHERE 
			Id_Contrato <> 0  
			AND Fecha >= @pFecha_Desde 
			AND Fecha <  dateadd(dd,1,@pFecha_Hasta) 
		END

		SET @cadaDiaAGenerar = @pFecha_Desde	
	
		WHILE(@cadaDiaAGenerar <= @pFecha_Hasta)
		BEGIN		
			SET @Dia_De_La_Semana = DATENAME(WEEKDAY, @cadaDiaAGenerar) --Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Dia contrato : ' + @Dia_De_La_Semana + '(' + CONVERT(VARCHAR(10), @cadaDiaAGenerar, 102) + ')'
			END

			IF @pId_Contrato <> 0
			BEGIN
				INSERT INTO CRM_Turnos
				(Id_Usuario,			Id_Cliente,			Id_Recurso, 
				Fecha,					Descripcion,		Estado,
				Id_Trans,				Id_Recurso_Horario,	Frecuencia,
				Fecha_Generacion,       Id_Contrato)

				SELECT 	@pId_Usuario,
						C.id_cliente,
						R.id_recurso,
						CONVERT(datetime,LEFT(CONVERT(VARCHAR(20),@cadaDiaAGenerar,112),8) + ' ' + LEFT(CONVERT(VARCHAR(20),H.DESDE,14),8)),
						'',
						'R',
						0,
						0,
						DATEDIFF(mi,H.Desde,H.Hasta),
						GETDATE(),
						C.ID_CONTRATO
						FROM CONTRATOS C, Contratos_Prod_Horarios P, Prod_Familias_Hor_Recursos R, Contratos_Prod_Programas_Hor H, Contratos_Prod_Programas CPP
						where 
						c.id_contrato = p.id_contrato 
						AND p.Id_Prod_Familia_Horario = r.Id_Prod_Familia_Horario
						AND cpp.id_contrato = c.id_contrato 
						AND C.ID_CONTRATO = @pId_Contrato
						AND h.Id_CPP = cpp.Id_CPP
						AND c.activo = 1
						AND c.Fecha_Desde <= @pFecha_Hasta
						AND c.Fecha_Desde <= @cadaDiaAGenerar
						AND isnull(c.Fecha_Hasta ,@pFecha_Desde) >=  @pFecha_Desde	
						AND c.Fecha_Hasta >= @cadaDiaAGenerar
						AND ((ISNULL(H.Lunes, 0) = 1  AND (@Dia_De_La_Semana = 'Monday'  OR  @Dia_De_La_Semana = 'Lunes'))  OR
							(ISNULL(H.Martes, 0) = 1 AND (@Dia_De_La_Semana = 'Tuesday' OR  @Dia_De_La_Semana = 'Martes')) OR
							(ISNULL(H.Miercoles, 0) = 1 AND (@Dia_De_La_Semana = 'Wednesday' OR @Dia_De_La_Semana = 'Miercoles')) OR
							(ISNULL(H.Jueves, 0) = 1  AND (@Dia_De_La_Semana = 'Thursday' OR  @Dia_De_La_Semana = 'Jueves')) OR
							(ISNULL(H.Viernes, 0) = 1 AND (@Dia_De_La_Semana = 'Friday' OR @Dia_De_La_Semana = 'Viernes')) OR
							(ISNULL(H.Sabado, 0) = 1  AND (@Dia_De_La_Semana = 'Saturday'  OR @Dia_De_La_Semana = 'Sabado')) OR
							(ISNULL(H.Domingo, 0) = 1 AND (@Dia_De_La_Semana = 'Sunday' OR @Dia_De_La_Semana = 'Domingo'))
						)
			END
			ELSE
			BEGIN
				IF (@pId_Recurso <> 0 AND @pId_Sector = 0)
				BEGIN
					INSERT INTO CRM_Turnos
					(Id_Usuario,			Id_Cliente,			Id_Recurso, 
					Fecha,					Descripcion,		Estado,
					Id_Trans,				Id_Recurso_Horario,	Frecuencia,
					Fecha_Generacion,       Id_Contrato)

					SELECT 
					@pId_Usuario,
					C.id_cliente,
					R.id_recurso,
					CONVERT(DATETIME,LEFT(CONVERT(VARCHAR(20),@cadaDiaAGenerar,112),8) + ' ' + LEFT(CONVERT(VARCHAR(20),H.DESDE,14),8)),
					'',
					'R',
					0,
					0,
					Datediff(mi,H.Desde,H.Hasta),
					GETDATE(),
					C.ID_CONTRATO
					FROM CONTRATOS C, Contratos_Prod_Horarios P, Prod_Familias_Hor_Recursos R, Contratos_Prod_Programas_Hor H, Contratos_Prod_Programas CPP
					WHERE 
					c.id_contrato = p.id_contrato 
					AND p.Id_Prod_Familia_Horario = r.Id_Prod_Familia_Horario
					AND cpp.id_contrato = c.id_contrato 
					AND R.ID_RECURSO = @pID_RECURSO
					AND h.Id_CPP = cpp.Id_CPP
					AND c.activo = 1
					AND c.Fecha_Desde <= @pFecha_Hasta
					AND c.Fecha_Desde <= @cadaDiaAGenerar
					AND isnull(c.Fecha_Hasta ,@pFecha_Desde) >=  @pFecha_Desde	
					AND c.Fecha_Hasta >= @cadaDiaAGenerar
					AND ((ISNULL(H.Lunes, 0) = 1  AND (@Dia_De_La_Semana = 'Monday'  OR  @Dia_De_La_Semana = 'Lunes'))  OR
						(ISNULL(H.Martes, 0) = 1 AND (@Dia_De_La_Semana = 'Tuesday' OR  @Dia_De_La_Semana = 'Martes')) OR
						(ISNULL(H.Miercoles, 0) = 1 AND (@Dia_De_La_Semana = 'Wednesday' OR @Dia_De_La_Semana = 'Miercoles')) OR
						(ISNULL(H.Jueves, 0) = 1  AND (@Dia_De_La_Semana = 'Thursday' OR  @Dia_De_La_Semana = 'Jueves')) OR
						(ISNULL(H.Viernes, 0) = 1 AND (@Dia_De_La_Semana = 'Friday' OR @Dia_De_La_Semana = 'Viernes')) OR
						(ISNULL(H.Sabado, 0) = 1  AND (@Dia_De_La_Semana = 'Saturday'  OR @Dia_De_La_Semana = 'Sabado')) OR
						(ISNULL(H.Domingo, 0) = 1 AND (@Dia_De_La_Semana = 'Sunday' OR @Dia_De_La_Semana = 'Domingo'))
					)
				END


				IF @pId_Sector <> 0
				BEGIN
					INSERT INTO CRM_Turnos
					(Id_Usuario,			Id_Cliente,			Id_Recurso, 
					Fecha,					Descripcion,		Estado,
					Id_Trans,				Id_Recurso_Horario,	Frecuencia,
					Fecha_Generacion,       Id_Contrato)

					SELECT 
					@pId_Usuario,
					C.id_cliente,
					R.id_recurso,
					CONVERT(datetime,LEFT(CONVERT(VARCHAR(20),@cadaDiaAGenerar,112),8) + ' ' + LEFT(CONVERT(VARCHAR(20),H.DESDE,14),8)),
					'',
					'R',
					0,
					0,
					Datediff(mi,H.Desde,H.Hasta),
					GETDATE(),
					C.ID_CONTRATO
					FROM CONTRATOS C, Contratos_Prod_Horarios P, Empresas_Sedes_Sec_Recursos S, Prod_Familias_Hor_Recursos R, Contratos_Prod_Programas_Hor H, Contratos_Prod_Programas CPP
					WHERE 
					c.id_contrato = p.id_contrato 
					AND p.Id_Prod_Familia_Horario = r.Id_Prod_Familia_Horario
					AND cpp.id_contrato = c.id_contrato 
					AND S.Id_Sector = @pId_Sector
					AND R.ID_RECURSO = S.ID_RECURSO
					AND h.Id_CPP = cpp.Id_CPP
					AND c.activo = 1
					AND c.Fecha_Desde <= @pFecha_Hasta
					AND c.Fecha_Desde <= @cadaDiaAGenerar
					AND isnull(c.Fecha_Hasta ,@pFecha_Desde) >=  @pFecha_Desde	
					AND c.Fecha_Hasta >= @cadaDiaAGenerar
					AND ((ISNULL(H.Lunes, 0) = 1  AND (@Dia_De_La_Semana = 'Monday'  OR  @Dia_De_La_Semana = 'Lunes'))  OR
						(ISNULL(H.Martes, 0) = 1 AND (@Dia_De_La_Semana = 'Tuesday' OR  @Dia_De_La_Semana = 'Martes')) OR
						(ISNULL(H.Miercoles, 0) = 1 AND (@Dia_De_La_Semana = 'Wednesday' OR @Dia_De_La_Semana = 'Miercoles')) OR
						(ISNULL(H.Jueves, 0) = 1  AND (@Dia_De_La_Semana = 'Thursday' OR  @Dia_De_La_Semana = 'Jueves')) OR
						(ISNULL(H.Viernes, 0) = 1 AND (@Dia_De_La_Semana = 'Friday' OR @Dia_De_La_Semana = 'Viernes')) OR
						(ISNULL(H.Sabado, 0) = 1  AND (@Dia_De_La_Semana = 'Saturday'  OR @Dia_De_La_Semana = 'Sabado')) OR
						(ISNULL(H.Domingo, 0) = 1 AND (@Dia_De_La_Semana = 'Sunday' OR @Dia_De_La_Semana = 'Domingo'))
					)
				END
			END

			SET @cadaDiaAGenerar += 1
		END	--BEGIN		

	END
			
	/*===================================================================*/	

	IF @pFlagUsarTrans <> 0 COMMIT

	SELECT	 0							AS ErrorNumber 
			,0							AS ErrorSeverity  
			,0							AS ErrorState 
			,0							AS ErrorProcedure  
			,@Cantidad_Turnos_Generados	AS ErrorLine		
			,''							AS ErrorMessage

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Turnos_Generar'
	END
	
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0  ROLLBACK

	RETURN 9999
END CATCH

RETURN 0 

--Ejemplo de uso
--EXEC CPJ_Turnos_Generar '{"FlagUsarTrans":"0", "ModoDebug":"1", "Id_Usuario":"-1", "Id_Sector":"8", "Fecha_Desde":"20200801", "Fecha_Hasta":"20200805"}'
